<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateWorkExperienceTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 11,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'nama_perusahaan' => [
                'type'       => 'VARCHAR',
                'constraint' => '200',
            ],
            'posisi' => [
                'type'       => 'VARCHAR',
                'constraint' => '200',
            ],
            'tahun_mulai' => [
                'type'       => 'YEAR',
                'null'       => true,
            ],
            'tahun_selesai' => [
                'type'       => 'YEAR',
                'null'       => true,
            ],
            'deskripsi' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'urutan' => [
                'type'       => 'INT',
                'constraint' => 11,
                'default'    => 0,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->addKey('urutan');
        $this->forge->createTable('work_experience');
    }

    public function down()
    {
        $this->forge->dropTable('work_experience');
    }
}


